/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.AbstractRangeValidator;

public class StringValidator
extends AbstractRangeValidator<Integer, String> {
    private static final long serialVersionUID = 1L;

    public StringValidator(Integer minimum, Integer maximum) {
        this.setRange(minimum, maximum);
    }

    protected StringValidator() {
    }

    @Override
    protected Integer getValue(IValidatable<String> validatable) {
        return validatable.getValue().length();
    }

    @Override
    protected ValidationError decorate(ValidationError error, IValidatable<String> validatable) {
        error = super.decorate(error, validatable);
        error.setVariable("length", validatable.getValue().length());
        return error;
    }

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
        Integer minimum;
        super.onComponentTag(component, tag);
        String tagName = tag.getName().toLowerCase(Locale.ENGLISH);
        boolean hasLengthAttribute = this.hasLengthAttribute(tagName);
        Integer maximum = (Integer)this.getMaximum();
        if (maximum != null && hasLengthAttribute) {
            tag.put("maxlength", maximum);
        }
        if ((minimum = (Integer)this.getMinimum()) != null && hasLengthAttribute) {
            tag.put("minlength", minimum);
        }
    }

    private boolean hasLengthAttribute(String tagName) {
        return "input".equalsIgnoreCase(tagName) || "textarea".equalsIgnoreCase(tagName);
    }

    public static StringValidator exactLength(int length) {
        return new StringValidator(length, length);
    }

    public static StringValidator maximumLength(int length) {
        return new StringValidator(null, length);
    }

    public static StringValidator minimumLength(int length) {
        return new StringValidator(length, null);
    }

    public static StringValidator lengthBetween(int minimum, int maximum) {
        return new StringValidator(minimum, maximum);
    }
}

